#ifndef IPWM_H
#define IPWM_H

// <<< Use Configuration Wizard in Context Menu >>>
	// <e> IPWM Enable/Disable
		#define dIPWM_MODE 	1
			#if (dIPWM_MODE == 1)	
				// <o> IPWM Frequency SET  (unit:Hz)
					#define IPWM_Frequency 	3900
					#define IPWM_Counter 	(unsigned int) 	((48000000/IPWM_Frequency)/2)
					#define PwmDuty 		(unsigned int) 	(IPWM_Counter/2)
					
				// <o.1..2> IPWM MODE SET <0=> Force Low <1=> Force High <2=> Active High <3=> Active Low
					#define IPWM_MODE 		 0x04
					#define IPWM_EN 		(IPWM_MODE|0x01)
					#define IPWM_DIS		(IPWM_MODE&0xF6)	
				
				// <h> Set buzzer working time
					// <o> IPWM Times_Init  (unit:times)<1-255>
						#define IPWM_TIMES_Init			1
						
					// <o> IPWM Enable time_Init  (unit:ms)<1-10000>
						#define IPWM_RUN_TIME_Init		250
						
					// <o> IPWM Disable time_Init  (unit:ms)<1-10000>
						#define IPWM_STOP_TIME_Init		50
					
					// <o> IPWM Times_OFF  (unit:ms)<1-255>
						#define IPWM_TIMES_OFF			1
						
					// <o> IPWM Enable time_OFF  (unit:ms)<1-10000>
						#define IPWM_RUN_TIME_OFF		500
						
					// <o> IPWM Disable time_OFF  (unit:ms)<1-10000>
						#define IPWM_STOP_TIME_OFF		50
					
					// <o> IPWM Times_Smart  (unit:ms)<1-255>
						#define IPWM_TIMES_Smart  		2
      
					// <o> IPWM Enable time_Smart  (unit:ms)<1-10000>
						#define IPWM_RUN_TIME_Smart  200
      
					// <o> IPWM Disable time_Smart  (unit:ms)<1-10000>
						#define IPWM_STOP_TIME_Smart  100
			
					// <o> IPWM Times_Others  (unit:ms)<1-255>
						#define IPWM_TIMES_Others		1
						
					// <o> IPWM Enable time_Others  (unit:ms)<1-10000>
						#define IPWM_RUN_TIME_Others	100
						
					// <o> IPWM Disable time_Others  (unit:ms)<1-10000>
						#define IPWM_STOP_TIME_Others	50
												
					// <o> IPWM Enable time_Err  (unit:ms)<1-10000>
						#define IPWM_RUN_TIME_Err		50
						
					// <o> IPWM Disable time_Err  (unit:ms)<1-10000>
						#define IPWM_STOP_TIME_Err		300
				// </h>
			#endif
	// </e>
// <<< end of configuration section >>>

#if (dIPWM_MODE == 1)
extern	xdata 	unsigned int 	ipwm_counter;
extern	xdata	unsigned char	Buzzer_TIMES;
extern void 	IPWM_Init (void);
extern void 	Buzzer_Fun (void);
#endif

#endif